<?php

/**
 * @version    CVS: 1.0.0
 * @package    Com_Sitemaxxi
 * @author     Fernando <contato@fernandomarinho.net>
 * @copyright  2016 Fernando
 * @license    GNU General Public License versão 2 ou posterior; consulte o arquivo License. txt
 */
// No direct access
defined('_JEXEC') or die;

/**
 * Sitemaxxi helper.
 *
 * @since  1.6
 */
class SitemaxxiHelpersSitemaxxi
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string  $vName  string
	 *
	 * @return void
	 */
	public static function addSubmenu($vName = '')
	{
				JHtmlSidebar::addEntry(
			JText::_('COM_SITEMAXXI_TITLE_SITEMAXXIS'),
			'index.php?option=com_sitemaxxi&view=sitemaxxis',
			$vName == 'sitemaxxis'
		);
	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return    JObject
	 *
	 * @since    1.6
	 */
	public static function getActions()
	{
		$user   = JFactory::getUser();
		$result = new JObject;

		$assetName = 'com_sitemaxxi';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action)
		{
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}
}


class SitemaxxiHelper extends SitemaxxiHelpersSitemaxxi
{

}
